
///////////////////////////////////////////////////////////////////////////////
//
//   ROCKWELL SEMICONDUCTOR SYSTEMS - COMMERCIAL GPS BUSINESS
//
///////////////////////////////////////////////////////////////////////////////
//
//
//   DISPLAY.H - Display Constants
// 
//
//   DESCRIPTION
//
//   Definitions of constants used to control the position of items displayed
//   on the screen.
//
//
//   REVISION HISTORY
//
//   $Log:   V:\Projects\Labmon\Include\Archives\DISPLAY.H_v  $
//   
//      Rev 1.17   08 Dec 1999 16:27:38   phungh
//   Add #define for Magna Control Mode display
//   and Magna Measurement display
//   
//      Rev 1.16   21 Apr 1999 11:45:30   phungh
//   Labmon54 : Add coordinate for displaying
//   msg1050 and msg1051
//   
//      Rev 1.15   06 Nov 1998 17:46:54   phungh
//   Labmon51: Fix file logging and missing
//   logged data bugs.  Changes made to the
//   "Pause" variable ( 1 -> 0 ) to allow main
//   loop continue.  Move the write to file code
//   portion out of the interrupt hander so that
//   data is not missed because of time spent
//   too long in the interrupt handler.
//   
//      Rev 1.3   Jul 09 1997 09:32:10   COLEJ
//   Multiple Changes...
//   
//      Rev 1.2   Feb 12 1997 16:04:36   COLEJ
//    
//   
//      Rev 1.1   Aug 13 1996 13:09:10   COLEJ
//    
//   
//      Rev 1.0   13 May 1996 14:54:18   GPSADMIN
//   Initial release to version control.
//
//
////////////////////////////////////////////////////////////////////////////////

#define BITC 17       // zodiac BIT info block col
#define BITR 12       // zodiac BIT info block row
#define CBEC 18       // clock bias error, drift info block col
#define CBER 22       // clock bias error, drift info block row
#define CBDC 34       // clock bias, drift info block col
#define CBDR 22       // clock bias, drift info block row
#define CHNC  2       // channel info block col
#define CHNR 28       // channel info block row
#define CMDC  1       // command line col
#define CMDR 43       // command line row
#define CNTC 61       // message count info block col
#define CNTR  1       // message count info block row
#define CPBC 57       // carrier phase bias info block col
#define CPBR 28       // carrier phase bias info block row
#define CPMC 20       // carrier phase info block col
#define CPMR 28       // carrier phase info block row
#define DOPC 16       // DOP info block col
#define DOPR  3       // DOP info block row
#define DGSC 70       // DGPS status info block col
#define DGSR 28       // DGPS status info block row
#define DSTC 74       // DGPS status block col 
#define DSTR 22       // DGPS status block row
#define GEOC 14       // geoidal and datum info block col
#define GEOR 10       // geoidal and datum info block row
#define HERC  2       // hor, vert position err info block col 
#define HERR 22       // hor, vert position err info block row
#define LATC  2       // lat, lon and position info block col
#define LATR 14       // lat, lon and position info block row
#define MODC  2       // mode info block col
#define MODR  1       // mode info block row
#define MSGC 70       // message acknowledge block col 
#define MSGR 20       // message acknowledge block row
#define PMSC  2       // PM status block col
#define PMSR  6       // PM status block row
#define PRTC 27       // port settings info block col
#define PRTR 10       // port settings info block row
#define POSC  2       // ECEF position info block col
#define POSR 18       // ECEF position info block row
#define PRMC 34       // pseudorange info block col
#define PRMR 28       // pseudorange info block row
#define REPC 61       // replay menu col 
#define REPR 17       // replay menu row
#define RTEC 53       // number of RTCM errors block col 
#define RTER 30       // number of RTCM errors block row
#define RTHC  2       // RTCM header info block col  
#define RTHR 30       // RTCM header info block row
#define RTNC 32       // number of RTCM messages block col 
#define RTNR 30       // number of RTCM messages block row
#define SETC  2       // user settings info block col 
#define SETR  5       // user settings info block row
#define SOGC 20       // SOG, COG info block col 
#define SOGR 14       // SOG, COG info block row
#define SPDC 32       // speed block col 
#define SPDR 14       // speed block row
#define TIMC 27       // time info block col
#define TIMR  1       // time info block row
#define TY1C  2       // Type 1 RTCM data block col 
#define TY1R 34       // Type 1 RTCM data block row
#define TY2C 32       // Type 2 RTCM data block col 
#define TY2R 34       // Type 2 RTCM data block row
#define TY5C 63       // Type 5 RTCM data block col
#define TY5R 34       // Type 5 RTCM data block row
#define VELC 20       // velocity info block col
#define VELR 18       // velocity info block row
#define VISC 46       // visibility info block col
#define VISR  2       // visibility info block row
#define DRFR 18       // dr flags block row (1170)
#define DRFC 32       // dr flags block col (1170)
#define DRSR 18       // dr speed block row (1171)
#define DRSC 46       // dr speed block col (1171)
#define MAGR 22		  // Magna Control row (1192)
#define MAGC 46		  // Magna Control column (1192)
#define RAMR 15       // Ram status row (1050)
#define RAMC 46       // Ram status column (1050)
#define DRER 16       // DR System status row (1051)
#define DREC 46       // DR System status row (1051)  
#define MATR 27		  // Match Filter Measurement row(1191)
#define MATC 62		  // Match Filter Measurement column(1191)
